//=============================================================================
// Parent Class.
//=============================================================================
class PartsBag extends DeusExPickup;

#exec AUDIO IMPORT FILE="Sounds\InsufficientScrap.wav" NAME="InsufficientScrap" GROUP="Bench"
#exec AUDIO IMPORT FILE="Sounds\PurchaseSuccess.wav" NAME="PurchaseSuccess" GROUP="Bench"
#exec AUDIO IMPORT FILE="Sounds\BreakdownPart2.wav" NAME="BreakdownPart" GROUP="Bench"


#exec TEXTURE IMPORT FILE="Textures\PartsWindow256.pcx"	NAME="PartsWindow256"	GROUP="UI" MIPS=Off FLAGS=2
#exec TEXTURE IMPORT FILE="Textures\PartsWindow384a.pcx"	NAME="PartsWindow384a"	GROUP="UI" MIPS=Off FLAGS=2
#exec TEXTURE IMPORT FILE="Textures\PartsWindow384b.pcx"	NAME="PartsWindow384b"	GROUP="UI" MIPS=Off FLAGS=2
#exec TEXTURE IMPORT FILE="Textures\IconPartsBag2.pcx"	NAME="IconPartsBag"	GROUP="Icons" MIPS=Off FLAGS=2

#exec TEXTURE IMPORT FILE="Textures\ScrapMetalWB.pcx"	NAME="ScrapMetalWB"	GROUP="Icons" MIPS=Off FLAGS=2


#exec MESH IMPORT MESH=PartsBag ANIVFILE=MODELS\PartsBag_a.3d DATAFILE=MODELS\PartsBag_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=PartsBag X=0 Y=0 Z=100 

#exec MESH SEQUENCE MESH=PartsBag SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=PartsBag SEQ=PartsBag STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=PartsBag MESH=PartsBag
#exec MESHMAP SCALE MESHMAP=PartsBag X=0.0214850625 Y=0.0214850625 Z=0.0214850625

#exec TEXTURE IMPORT FILE="Textures\PBBrown.pcx"	NAME="PBBrown"	GROUP="Skins" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\PBWhite.pcx"	NAME="PBWhite"	GROUP="Skins" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\PBDGray.pcx"	NAME="PBDGray"	GROUP="Skins" MIPS=Off

#exec MESHMAP SETTEXTURE MESHMAP=PartsBag NUM=0 TEXTURE=PBBrown
#exec MESHMAP SETTEXTURE MESHMAP=PartsBag NUM=1 TEXTURE=PBWhite
#exec MESHMAP SETTEXTURE MESHMAP=PartsBag NUM=2 TEXTURE=PBDGray

state Activated
{
	function Activate()
	{
	 InvokeInventory();
	 GoToState('DeActivated');
	 return;
	}

	function BeginState()
	{
	 InvokeInventory();
	 GoToState('DeActivated');
	 return;
	}
Begin:
}

function MSMassEffectMutator GetMutator()
{
 local MSMassEffectMutator M; 
 
 forEach AllActors(class'MSMassEffectMutator', M)
 {
  if (M != None) return M;
 }
 
 return None;
}

function InvokeInventory()
{
 local DeusExPlayer P;
 local DeusExRootWindow Root;
 local PartDisplayWindow PartWindow;
 
 P = DeusExPlayer(Owner);
 
 if (P.RootWindow != None)
 {
  //DeusExRootWindow(P.RootWindow).VirtualKeyPressed(IK_Escape, False);
  //DeusExRootWindow(P.RootWindow).RawKeyPressed(IK_Escape, IST_Press, False);
 }
 
 if(P != None)
 {
  P.InitRootWindow();
  Root = DeusExRootWindow(P.rootWindow);
  
  if(Root != None)
  {
   PartWindow = PartDisplayWindow(Root.InvokeMenuScreen(Class'PartDisplayWindow', True));
   
   if(PartWindow != None)
   {
    PartWindow.PartsBag = self;
    PartWindow.Player = P;
    PartWindow.Mutator = GetMutator();
    PartWindow.UpdateInfo();
   }
  }
 }
}

defaultproperties
{
     InvSlotsX=1
     InvSlotsY=1

     bActivatable=True
     ItemName="Parts Bag"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'MSMassEffect.PartsBag'
     PickupViewMesh=LodMesh'MSMassEffect.PartsBag'
     ThirdPersonMesh=LodMesh'MSMassEffect.PartsBag'
     LandSound=Sound'DeusExSounds.Generic.PaperHit1'
     Icon=Texture'IconPartsBag'
     largeIcon=Texture'IconPartsBag'
     largeIconWidth=44
     largeIconHeight=44
     Description="A bag for storing and holding weapon parts."
     beltDescription="PARTS"
     Mesh=LodMesh'MSMassEffect.PartsBag'
     CollisionRadius=4.000000
     CollisionHeight=4.000000
     Mass=30.000000
     Buoyancy=20.000000
}
